#### 각 setting 별로 생성된 df, W를 simulationRun.R 내의 df, W의 인자로 사용.
###########################################################
###########################################################
###########################################################
#### Transform 1 (setting 1, Oldtransform)

n = 1000 # obs 수는 1000,2000 조절 가능능
set.seed(123)
# Treatment variable : F
F = rbinom(n, 1, 0.5)
# X1, X2, X3 : Joint Normal RV
mu = cbind(4*(2*F-1),
           6*(2*F-1),
           0)

Sigma = matrix(c(2, 1  , -1, 
                 1, 1  , -0.5, 
                 -1,-0.5,   1), nrow = 3)
X1X2X3 = data.frame(t(apply(mu, 1, function(m) mvrnorm(1, mu = m, Sigma = Sigma))))
colnames(X1X2X3)= c("X1","X2","X3")
# X4, X5, X6
X4 = runif(n,-3,3); X5 = rchisq(n,1); X6 = rbinom(n,1,0.5)
# Gaussian random noises
eps = rnorm(n,0,1); delta = rnorm(n,0,15)

df = data.frame(F,X1X2X3,X4,X5,X6,eps,delta)
df = df %>%
  mutate(A = as.integer(F + F * X1 + 2 * X2 - 2 * X3 - X4 - 0.5 * X5 + X6 + delta > 0))
# Y
tri = function(x) pmax(1-abs(x),0)
df = df %>% 
  mutate(Y = (X1 + X2 + X5)^2 + A * tri((X1-2)/2) + (1-A) * tri((X1+2)/2) + eps)
# Select F,X,A,Y
df = df %>%
  dplyr::select(F, starts_with("X"), A, Y)

# W = (X* : transformed covariates , F)
W = df %>%
  mutate(
    X1X3 = X1*X3,
    X2sq = X2^2) %>%
  dplyr::select(X1X3, X2sq ,X4, X5, X6, F)
###########################################################
###########################################################
###########################################################
###########################################################
###########################################################
###########################################################
#### Transform 2 (setting 2, newtransform)
sigmoid = function(x) 1/(1+exp(-x))
n = 1000 # obs 수는 1000,2000 조절 가능능
set.seed(123)
# Treatment variable : F
F = rbinom(n, 1, 0.5)
# X1, X2, X3 : Joint Normal RV
mu = cbind(2*(2*F-1),
           2*(2*F-1),
           0)
# mu = cbind(2*(2*F-1),
#            0,
#            0)
Sigma = matrix(c(2, 1  , -1, 
                 1, 1  , -0.5, 
                 -1,-0.5,   1), nrow = 3)
X1X2X3 = data.frame(t(apply(mu, 1, function(m) mvrnorm(1, mu = m, Sigma = Sigma))))
colnames(X1X2X3)= c("X1","X2","X3")
# X4, X5, X6
X4 = runif(n,-3,3); X5 = rchisq(n,1); X6 = rbinom(n,1,0.5)
# Gaussian random noises
eps = rnorm(n,0,1); delta = rnorm(n,0,5)

df = data.frame(F,X1X2X3,X4,X5,X6,eps,delta)
df = df %>%
  mutate(A = as.integer(F + F * X1 + 2 * X2 - 2 * X3 - X4 - 0.5 * X5 + X6 + delta > 0))
# Y
tri = function(x) pmax(1-abs(x),0)
df = df %>% 
  mutate(Y = (X1 + X2 + X5)^2 + A * tri((X1-2)/2) + (1-A) * tri((X1+2)/2) + eps)
# Select F,X,A,Y
df = df %>%
  dplyr::select(F, starts_with("X"), A, Y)

# W = (X* : transformed covariates , F)
W = df %>%
  mutate(
    X1X3 = X1*X3,
    X2sq = X2^2,
    sigX6 = sigmoid(X6),
    hlogX5 = 0.5*log(X5)) %>%
  dplyr::select(X1X3, X2sq ,X4, hlogX5, sigX6, F)

###########################################################
###########################################################
###########################################################
###########################################################
###########################################################
###########################################################

